/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.session;

import com.google.gson.Gson;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.PublicKey;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.WillClose;
import net.creeperhost.minetogether.session.InvalidJWebToken;
import net.creeperhost.minetogether.session.JWebToken;
import net.creeperhost.minetogether.session.KeyUtil;
import net.creeperhost.minetogether.session.SessionValidationException;
import net.creeperhost.minetogether.session.data.AuthRequest;
import net.creeperhost.minetogether.session.data.AuthResponse;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MineTogetherSession {
    private static final Logger LOGGER = LoggerFactory.getLogger(MineTogetherSession.class);
    private static final Gson GSON = new Gson();
    private final SessionServer server;
    private final Path sessionStorage;
    private final UUID uuid;
    private final String username;
    private final Supplier<String> beginAuthCallback;
    @Nullable
    private JWebToken token;

    public MineTogetherSession(Path sessionStorage, UUID uuid, String username, Supplier<String> beginAuthCallback) {
        this(SessionServer.DEFAULT, sessionStorage, uuid, username, beginAuthCallback);
    }

    public MineTogetherSession(SessionServer server, Path sessionStorage, UUID uuid, String username, Supplier<String> beginAuthCallback) {
        this.server = server;
        this.sessionStorage = sessionStorage;
        this.uuid = uuid;
        this.username = username;
        this.beginAuthCallback = beginAuthCallback;
    }

    public boolean isValid() {
        return this.token != null && this.token.isValid(this.server.publicKey) && this.token.getUuid().equals(this.uuid);
    }

    public void validate() throws SessionValidationException {
        String token;
        Path sessionFile = this.sessionStorage.resolve(this.uuid + ".session");
        if (this.token == null && Files.exists(sessionFile, new LinkOption[0])) {
            try {
                this.token = JWebToken.parse(new String(Files.readAllBytes(sessionFile), StandardCharsets.UTF_8));
            }
            catch (IOException | InvalidJWebToken ex) {
                LOGGER.warn("Failed to load session. New session will be obtained.", (Throwable)ex);
            }
        }
        if (this.isValid()) {
            return;
        }
        this.token = null;
        try {
            token = this.requestToken();
        }
        catch (IOException ex) {
            throw new SessionValidationException("Failed to acquire new session.", ex);
        }
        try {
            this.token = JWebToken.parse(token);
        }
        catch (InvalidJWebToken ex) {
            throw new SessionValidationException("New session token is corrupt?", ex);
        }
        try {
            if (Files.notExists(sessionFile.getParent(), new LinkOption[0])) {
                Files.createDirectories(sessionFile.getParent(), new FileAttribute[0]);
            }
            Files.write(sessionFile, token.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException ex) {
            LOGGER.warn("Failed to write session token to disk.", (Throwable)ex);
        }
    }

    public JWebToken getToken() {
        if (this.token == null) {
            throw new IllegalStateException("Expected session to be validated.");
        }
        return this.token;
    }

    private String requestToken() throws IOException {
        IOException error = null;
        for (int i = 0; i < 3; ++i) {
            try {
                String response = this.runTokenRequest();
                AuthResponse resp = (AuthResponse)GSON.fromJson(response, AuthResponse.class);
                if ("success".equals(resp.status)) {
                    return resp.token;
                }
                throw new IOException("Failed session token request. Got API Error: " + resp.message);
            }
            catch (IOException ex) {
                if (error == null) {
                    error = ex;
                    continue;
                }
                error.addSuppressed(ex);
                continue;
            }
        }
        throw error;
    }

    /*
     * Loose catch block
     */
    private String runTokenRequest() throws IOException {
        AuthRequest request = new AuthRequest();
        request.minecraft = new AuthRequest.MinecraftAuth();
        request.minecraft.username = this.username;
        request.minecraft.uuid = this.uuid;
        request.minecraft.serverId = this.beginAuthCallback.get();
        String payload = GSON.toJson((Object)request);
        URL url = new URL(this.server.host + "/api/v1/auth");
        HttpURLConnection connection = null;
        try {
            String string;
            Throwable throwable;
            InputStream is;
            block33: {
                block34: {
                    connection = (HttpURLConnection)url.openConnection();
                    connection.setRequestMethod("PUT");
                    connection.setRequestProperty("Content-Type", "application/json");
                    connection.setDoOutput(true);
                    OutputStream os = connection.getOutputStream();
                    os.write(payload.getBytes(StandardCharsets.UTF_8));
                    is = connection.getInputStream();
                    throwable = null;
                    string = new String(MineTogetherSession.readAll(is), StandardCharsets.UTF_8);
                    if (is == null) break block33;
                    if (throwable == null) break block34;
                    try {
                        is.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block33;
                }
                is.close();
            }
            return string;
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (is != null) {
                            if (throwable != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                is.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (IOException ex) {
                    Throwable throwable6;
                    InputStream is2;
                    block35: {
                        String string2;
                        block36: {
                            block37: {
                                is2 = connection.getErrorStream();
                                throwable6 = null;
                                if (is2 == null) break block35;
                                string2 = new String(MineTogetherSession.readAll(is2), StandardCharsets.UTF_8);
                                if (is2 == null) break block36;
                                if (throwable6 == null) break block37;
                                try {
                                    is2.close();
                                }
                                catch (Throwable throwable7) {
                                    throwable6.addSuppressed(throwable7);
                                }
                                break block36;
                            }
                            is2.close();
                        }
                        if (connection != null) {
                            connection.disconnect();
                        }
                        return string2;
                    }
                    try {
                        try {
                            throw ex;
                        }
                        catch (Throwable throwable8) {
                            throwable6 = throwable8;
                            throw throwable8;
                        }
                    }
                    catch (Throwable throwable9) {
                        if (is2 != null) {
                            if (throwable6 != null) {
                                try {
                                    is2.close();
                                }
                                catch (Throwable throwable10) {
                                    throwable6.addSuppressed(throwable10);
                                }
                            } else {
                                is2.close();
                            }
                        }
                        throw throwable9;
                    }
                }
            }
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private static byte[] readAll(InputStream is) throws IOException {
        int len;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((len = is.read(buf)) != -1) {
            bos.write(buf, 0, len);
        }
        return bos.toByteArray();
    }

    public static final class SessionServer {
        public static final SessionServer DEFAULT = SessionServer.create("https://sessions.minetogether.io", SessionServer.class.getResourceAsStream("/default-public.pem"));
        public final String host;
        public final PublicKey publicKey;

        public SessionServer(String host, PublicKey publicKey) {
            this.host = host.endsWith("/") ? host.substring(0, host.length() - 1) : host;
            this.publicKey = publicKey;
        }

        public static SessionServer create(String host, Path pemFile) {
            try {
                return SessionServer.create(host, Files.newInputStream(pemFile, new OpenOption[0]));
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        public static SessionServer create(String host, @WillClose @Nullable InputStream pemStream) {
            try {
                return new SessionServer(host, KeyUtil.loadPublicKeyPem(Objects.requireNonNull(pemStream)));
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        public static SessionServer create(String host, byte[] pemBytes) {
            try {
                return new SessionServer(host, KeyUtil.loadPublicKeyPem(pemBytes));
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

